#ifndef _H_SuperString
#define	_H_SuperString

#include "string.h"
#include <string>
#include <vector>

#define BEX_THROW(ERR)		throw ((long) ERR)	

#define BEX_TRY				{{ OSErr _err = noErr; try {
#define BEX_CATCH_PART1		}	catch (long _tmp_err) { _err = _tmp_err; } \
								catch(std::bad_alloc&) { _err = mFulErr; }
#define BEX_CATCH_PART2		if (_err) {
#define XTE_TRY(ERR)				if (! ERR) BEX_TRY
#define BEX_CATCH			BEX_CATCH_PART1 BEX_CATCH_PART2
#define XTE_CATCH					BEX_CATCH
#define BEX_ENDTRY			} if (_err) BEX_THROW(_err); }}

#define BEX_NO_PROPAGATE	_err = noErr
#define XTE_NO_PROPAGATE			BEX_NO_PROPAGATE
#define XTE_ENDTRY(ERR)				ERR = _err; XTE_NO_PROPAGATE; BEX_ENDTRY

#define ERR_XTE_START	XTE_TRY(err); { 
#define ERR_XTE_END		} XTE_CATCH { ; } XTE_ENDTRY(err)

#define ETX(EXPR)			{ OSErr _err = (EXPR); if (_err) BEX_THROW(_err); }
#define XTE(FUNC)		XTE_TRY(err) { (FUNC); } XTE_CATCH { ; } XTE_ENDTRY(err)

#define	memclr(p, s)	std::memset(p, 0, s)
#define	structclr(p)	memclr(&p, sizeof(p))
#define	pstrcpy(d, s)	std::memcpy(d, s, s[0] + 1)

#define		kKiloByte				1024
#define		kKiloBytef				1024.0f
#define		kMegaByte				(kKiloByte * kKiloByte)
#define		kGigaByte				(kMegaByte * kKiloByte)
#define		kTeraByte				(kGigaByte * kKiloByte)

#define ERR_(_ERR, FUNC)	if (!_ERR) { _ERR = (FUNC); }

#define ERR(FUNC)			ERR_(err, FUNC);
#define ERRL(FUNC, STR)		ERR(FUNC);
#define ERR2(FUNC)			{ OSStatus err2 = noErr; ERR_(err2, FUNC); if (!err) { err = err2; }}

#define	kFileType_WILDCARD	'????'

#define		RETURN_KEY			0x0D	//	'\r'
#define		LINEFEED_KEY		0x0A
#define		loop_reverse(_n)	for (long _indexS = ((_n) - 1); _indexS >= 0; _indexS--)
#define		loop(_n)			for (long _indexS = 0, _maxS = (_n); _indexS < _maxS; _indexS++)
#define		IsEOLN(_x)			(_x == '\r' || _x == '\n')

extern const char RETURN_STR[];
extern const char LINEFEED_STR[];

typedef std::vector<char>			CharVec;
typedef std::vector<char*>			CharPVec;
typedef std::vector<UTF16Char>		UTF16Vec;
typedef	std::vector<UInt32>			UInt32Vec;
typedef std::vector<unsigned char>	UCharVec;

typedef std::basic_string<UTF8Char, std::char_traits<UTF8Char>, std::allocator<UTF8Char> > ustring;
#define uc(_foo) (unsigned char *)(_foo)

OSStatus		CopyHandle(const Handle srcH, Handle *destHP);
char*			strrstr(const char* stringZ, const char* findZ);
ustring			&UpperString(ustring &str);

CFStringRef		CFStrCreateWithCurAbsTime();
CFURLRef		CFURLCreateWithUTF8(const UTF8Char *bufZ);
void			CFStrReplaceWith(CFMutableStringRef stringRef, CFStringRef replaceStr, CFStringRef withStr);
bool			CFStringIsEmpty(CFStringRef nameRef);
CFStringRef		CFStringCreateWithCu(
	const UTF8Char *	bufZ, 
	CFStringEncoding	encoding = kCFStringEncodingUTF8);
CFStringRef		CFStringCreateWithC(
	const char *		bufZ, 
	CFStringEncoding	encoding = kCFStringEncodingInvalidId);
ustring	&CopyCFStringToUString(
	CFStringRef			str, 
	ustring				&result, 
	CFStringEncoding	encoding = kCFStringEncodingUTF8, 
	bool				externalB = false);

std::string		&CopyCFStringToStd(
	CFStringRef			str, 
	std::string			&stdstr, 
	CFStringEncoding	encoding = kCFStringEncodingInvalidId);

CFStringEncoding	ValidateEncoding(CFStringEncoding encoding);
CFComparisonResult		CFStringCompare(CFStringRef str1, CFStringRef str2, bool case_sensitiveB = false);
bool			CFStringEqual(CFStringRef str1, CFStringRef str2, bool case_sensitiveB = false);
bool			CFStringLess(CFStringRef lhs, CFStringRef rhs, bool case_sensitiveB = false);

template <typename T>
class	ScCFReleaser {
	T	i_typeRef;
	
	public:
	ScCFReleaser(T typeRef = NULL) : i_typeRef(typeRef)	{}

	~ScCFReleaser() {
		if (i_typeRef) {
			CFRelease(i_typeRef);
			i_typeRef = NULL;
		}
	}
	 
	T	Retain()	{	CFRetain(i_typeRef);	return i_typeRef;	}
	T	Release()	{	CFRelease(i_typeRef);	return i_typeRef;	}

	T	Get()		{	return i_typeRef;	}
	T	Set(T typeRef)	{
	
		if (typeRef) {
			CFRetain(typeRef);
		}

		if (i_typeRef) {
			CFRelease(i_typeRef);
		}
		
		i_typeRef = typeRef;
		return i_typeRef;
	}
	
	T*	AddressOf()	{	return &i_typeRef;	}

	operator T()	{	return i_typeRef;	}
	operator T*()	{	return AddressOf();	}
	
	T	operator =(T typeRef)	{	return Set(typeRef);	}

	T	transfer()	{
		T	ret = i_typeRef;

		i_typeRef = NULL;
		return ret;
	}
};

class	UniString {
	UTF16Char	i_nullChar;
	UTF16Vec	*i_charVecP;
	
	void		UpdateNamePointer() {
		if (i_charVecP) {
			i_charVecP->push_back(0);
			i_nameP = &(*i_charVecP)[0];
		} else {
			i_nameP = &i_nullChar;
		}
	}
	
	public:
	void	Initialize(CFStringRef cf_name) {
		if (cf_name && !CFStringIsEmpty(cf_name)) {
			i_lengthL	= CFStringGetLength(cf_name);
			
			if (i_charVecP == NULL) {
				i_charVecP = new UTF16Vec();
			}
			
			i_charVecP->resize(i_lengthL);
			CFStringGetCharacters(cf_name, CFRangeMake(0, i_lengthL), &(*i_charVecP)[0]);
		} else {
			delete i_charVecP;
			i_charVecP = NULL;
			i_lengthL = 0;
		}

		UpdateNamePointer();
	}
	
	UniCharCount		i_lengthL;
	UniChar				*i_nameP;
	
	UniString(const UniString &uni)	: i_nameP(NULL), i_charVecP(NULL), i_nullChar(0) {
		i_lengthL	= uni.i_lengthL;
		
		if (i_lengthL) {
			i_charVecP = new UTF16Vec();
			i_charVecP->resize(i_lengthL);
			std::copy(&uni.i_nameP[0], &uni.i_nameP[i_lengthL], &(*i_charVecP)[0]);
		}

		UpdateNamePointer();
	}
	
	UniString(CFStringRef cf_name) : i_nameP(NULL), i_charVecP(NULL), i_nullChar(0) {
		Initialize(cf_name);
	}

	UniString(const char *nameZ = NULL) : i_nameP(NULL), i_charVecP(NULL), i_nullChar(0), i_lengthL(0) {
		if (nameZ) {
			ScCFReleaser<CFStringRef>	cf_name(CFStringCreateWithC(nameZ));
			
			Initialize(cf_name);
		}
	}
	
	~UniString() {
		delete i_charVecP;
	}
};

OSType			CharToOSType(const char *bufZ);

class SuperString {
	CFStringRef			i_ref;
	mutable std::string	*i_std;
	mutable UniString	*i_uni;
	mutable ustring		*i_utf8;
	mutable ustring		*i_pstr;
	
	public:
	const	std::string	&std() const	{	Update_std();	return *i_std;	}
	const	CFStringRef	&ref() const	{	return i_ref;	}
	const	UniString	&uni() const	{	Update_uni();	return *i_uni;	}
	const	ustring		&utf8() const	{	Update_utf8();	return *i_utf8;	}
	const	char *		c_str() const  	{	return std().c_str();	}
	const	char *		utf8Z() const	{	return (const char *)utf8().c_str();	}
	ConstStr255Param	p_str() const	{	Update_pstr();	return i_pstr->c_str();	}
	
	operator const UniString&() const	{	return uni();	}
	operator const std::string&() const	{	return std();	}
	//operator const ustring&() const		{	return utf8();	}	causes all sorts of ambiguities
	operator CFStringRef() const		{	return ref();	}
	operator const UInt8*() const		{	return utf8().c_str();	}

	/************************************/
	SuperString&	Truncate(bool activeB, const Rect& frameR);
	SuperString&	ssprintf(void *nul, ...);
	
	private:
	void	SetNULL()
	{
		i_ref	= NULL;
		i_std	= NULL;
		i_uni	= NULL;
		i_utf8	= NULL;
		i_pstr	= NULL;
	}
	
	public:
	SuperString(const char *strZ = NULL) {
		SetNULL();
		
		if (strZ) {
			Set(strZ);
		} else {
			Set(CFSTR(""));
		}
	}
	
	SuperString(const SuperString &sstr) {
		SetNULL();
		Set(sstr.ref());
	}
	
	SuperString(const HFSUniStr255 &str) {
		SetNULL();

		ScCFReleaser<CFStringRef>	myRef = CFStringCreateWithCharacters(
			kCFAllocatorDefault, 
			str.unicode,
			str.length);
		
		Set(myRef);
	}

	SuperString(const UInt16* strZ) {
		SetNULL();

		ScCFReleaser<CFStringRef>	myRef = strZ 
			? CFStringCreateWithC((const char *)strZ, kCFStringEncodingUnicode) : 
			(CFStringRef)CFRetain(CFSTR(""));

		Set(myRef);
	}

	SuperString(const UInt8 *strZ) {
		SetNULL();
		Set(strZ);
	}

	SuperString(long valL) {
		SetNULL();
		append(valL);
	}

	SuperString(const ustring &str) {
		SetNULL();
		Set(str.c_str());
	}

	SuperString(const std::string &str) {
		SetNULL();
		Set(str.c_str());
	}

	SuperString(CFStringRef myRef) {
		SetNULL();
		Set(myRef);
	}
	
	/************************************/
	void	Set_p(ConstStr255Param strZ);
	
	void	Set(const char *strZ) {
		ScCFReleaser<CFStringRef>	myRef = CFStringCreateWithC(strZ);
		
		Set(myRef);
	}

	void	Set(const UInt8 *strZ) {
		ScCFReleaser<CFStringRef>	myRef = strZ ? CFStringCreateWithCu(strZ) : (CFStringRef)CFRetain(CFSTR(""));

		Set(myRef);
	}

	void	Set(const UTF16Vec &vec) {
		ScCFReleaser<CFStringRef>	myRef = CFStringCreateWithCharacters(kCFAllocatorDefault, &vec[0], vec.size());

		Set(myRef);
	}

	void	Set(const SuperString &sstr) {
		if (&sstr != this) {
			Set(sstr.i_ref);
		}
	}
  
  	CFStringRef	Retain() const {	CFRetain(i_ref);	return i_ref;	}
  
	void	Set(CFStringRef myRef, bool retainB = true) {

		if (i_ref) {
			CFRelease(i_ref);
		}
		
		if (myRef == NULL) {
			myRef = CFSTR("");
		}
		
		i_ref = myRef;
		
		if (retainB) {
			CFRetain(i_ref);
		}
		
		delete i_uni;
		i_uni	= NULL;
		
		delete i_std;
		i_std	= NULL;
		
		delete i_utf8;
		i_utf8	= NULL;
		
		delete i_pstr;
		i_pstr = NULL;
	}

	/************************************/
	~SuperString() {
		Set((CFStringRef)NULL, false);
	}
	
	void	Release() {
		CFRelease(i_ref);
	}

	/************************************/
	void	Update_pstr() const {

		if (!i_pstr) {
			i_pstr = new ustring;
			i_pstr->push_back(0);
			Update_std();
			i_pstr->insert(i_pstr->end(), i_std->begin(), i_std->end());
			(*i_pstr)[0] = i_pstr->size() - 1;

			delete i_std;
			i_std	= NULL;
		}
	}
	
	void	Update_uni() const {
		if (!i_uni) {
			i_uni = new UniString(i_ref);
		}
	}

	void	Update_std() const {
		if (!i_std) {
			i_std = new std::string;
			CopyCFStringToStd(i_ref, *i_std);
		}
	}

	void	Update_utf8() const {
		if (!i_utf8) {
			i_utf8 = new ustring;
			CopyCFStringToUString(i_ref, *i_utf8);
		}
	}

	/************************************/
	void	clear()	{	Set("");	}
	
	bool				Contains(const SuperString& other) {
		return strstr(utf8Z(), other.utf8Z()) != NULL;
	}
	
	SuperString&		Replace(const SuperString& replaceStr, const SuperString& withStr) {
		ScCFReleaser<CFMutableStringRef>	newRef(CFStringCreateMutableCopy(NULL, 0, i_ref));

		CFStrReplaceWith(newRef, replaceStr.ref(), withStr.ref());
		Set(newRef);
		return *this;
	} 

	SuperString		&UnderScoresToSpaces() {
		return Replace("_", " ");
	}

/*
	ambiguous
	
	char			operator[](size_t indexS) {
		char	ch = 0;
		
		if (utf8().size() > indexS) {
			ch = utf8().c_str()[indexS];
		}
		
		return ch;
	}
*/
	
	void			ToUpper();
	void			ToLower();
	bool			IsAllCaps();
	SuperString&	InterCaps(bool allow_line_breaksB);

	SuperString&	operator =(const SuperString &other) {	Set(other);	return *this;	}
	SuperString&	operator =(const char *otherZ) {	Set(otherZ);	return *this;	}

	bool			operator<(CFStringRef other) const {
		return CFStringLess(i_ref, other);
	}
	
	bool			operator ==(CFStringRef other)	{
		return CFStringEqual(i_ref, other);
	}

	bool			operator ==(CFStringRef other) const {
		return CFStringEqual(i_ref, other);
	}

	bool			operator !=(CFStringRef other)	{
		return ! operator==(other);
	}

	bool			operator ==(const SuperString &other)	{
		return operator==(other.i_ref);
	}

	bool			operator !=(const SuperString &other)	{
		return ! operator==(other.i_ref);
	}

	bool	empty() const		{	return CFStringIsEmpty(i_ref);	}
	long	value_long() const	{	return ::atoi(c_str());	}
	
	void	pop_front(long numL = 1)	{
		if (strlen(utf8Z()) <= numL) {
			clear();
		} else {
			Set(&(utf8().c_str())[numL]);
		}
	}
	
	bool	Split(const char *splitZ, SuperString &rhs, bool from_endB = false) {
		bool	splitB;
		
		if (from_endB) {
			splitB = strrstr(utf8Z(), splitZ) != NULL;
		} else {
			splitB = strstr(utf8Z(), splitZ) != NULL;
		}
		
		if (splitB) {
			UTF8Char	bufAC[i_utf8->size() + 1];
			
			std::copy(i_utf8->begin(), i_utf8->end(), bufAC);
			bufAC[i_utf8->size()] = 0;
			
			UTF8Char	*chZ;
			
			if (from_endB) {
				chZ	= (UTF8Char *)strrstr((char *)bufAC, (char *)splitZ);
			} else {
				chZ	= (UTF8Char *)strstr((char *)bufAC, (char *)splitZ);
			}
		
			SuperString		temp(chZ + strlen(splitZ));
			*chZ = 0;
			Set(bufAC);

			rhs.Set(temp);
		}
		
		return splitB;
	}
	
	SuperString	&pop_back(UInt32 numCharsL = 1);

	OSType	&pop_ext(OSType *extP);
	
	SuperString	&pop_ext(SuperString *extP0 = NULL) {
		ustring				ustr(utf8());
		const unsigned char	*dotP;
		
		dotP = uc(strrchr(utf8Z(), '.'));
		
		if (dotP) {
			if (extP0) {
				extP0->Set(dotP);
			}
			
			ustr.resize(ustr.size() - strlen((char *)dotP));

			Set(ustr);
		}

		return *this;
	}
	
	/******************************/
	SuperString		&append(const ustring &other) {
		Set(utf8() + other);
		return *this;
	}

	SuperString		&append(SuperString &other) {
		return append(other.utf8());
	}

	SuperString		&append(CFStringRef myRef) {
		return append(SuperString(myRef).utf8());
	}

	SuperString		&append(const char *other) {
		return append(SuperString(other).utf8());
	}

	SuperString		&append(long valueL)
	{
		char	bufAC[32];
		
		::sprintf(bufAC, "%ld", valueL);
		return append(bufAC);
//		std::string		strStr;
		
//		return append(NumToCString(valueL, strStr));
	}
	
	/****************************/
	SuperString		&prepend(const ustring &other) {
		Set(other + utf8());
		return *this;
	}

	SuperString		&prepend(SuperString &other) {
		return prepend(other.utf8());
	}

	SuperString		&prepend(const char *other) {
		return prepend(SuperString(other).utf8());
	}

	SuperString		&prepend(long valueL) {
		char	bufAC[32];
		
		::sprintf(bufAC, "%.2ld", valueL);
		return prepend(bufAC);
	}
	
	OSType			GetAsOSType() const	{	return CharToOSType(utf8Z());	}
	SuperString		&Ascii();
};

SuperString		operator+(const SuperString &lhs, SuperString rhs);

char			*OSTypeToChar(OSType osType, char *bufZ);
SuperString		OSTypeToString(OSType osType);
inline OSType	GetExtension(const char *strZ)	{	return CharToOSType(&strZ[strlen(strZ) - 4]);	}
void			IncrementNumberAtEndOfString(SuperString *strP);

typedef std::vector<SuperString>	SStringVec;

#endif