#include "SuperString.h"

const char RETURN_STR[2]	=	{ RETURN_KEY, 0x00 };
const char LINEFEED_STR[2]	=	{ LINEFEED_KEY, 0x00 };

ustring		&UpperString(ustring &str)
{
	const UTF8Char	*strZ = str.c_str();
	UTF8Char		buf[str.size() + 1];
	
	loop (str.size()) {
		buf[_indexS] = toupper((char)strZ[_indexS]);
	}
	
	buf[str.size()] = 0;

	str = buf;
	return str;
}

char		*OSTypeToChar(OSType osType, char *bufZ)
{
	osType = OSSwapHostToBigInt32(osType);
	*((OSType *)bufZ) = osType;
	bufZ[4] = 0;
	return bufZ;
}

SuperString		OSTypeToString(OSType osType)
{
	SuperString		str;
	
	if (osType == -1) {
		str.Set("-");
	} else {
		char	bufAC[5];
		
		str.Set(OSTypeToChar(osType, bufAC));
	}
	
	return str;
}

CFStringRef			CFStrCreateWithCurAbsTime()
{
	AbsoluteTime		curTime = UpTime();
	char				bufAC[32];
	
	sprintf(bufAC, "%lu%lu", curTime.hi, curTime.lo);
	return CFStringCreateWithC(bufAC);
}

void		IncrementNumberAtEndOfString(SuperString *strP)
{
	ustring		ustr(strP->utf8());
	short		startOfNumS = ustr.size();
	
	while (isdigit(ustr[startOfNumS - 1])) {
		startOfNumS--;
	}

	if (startOfNumS == ustr.size()) {
		ustr.append(uc(" 1"));
	} else {
		int		numberI;
		char	numAC[32];
		
		sscanf((char *)&ustr[startOfNumS], "%d", &numberI);
		ustr.resize(startOfNumS);

		if (ustr[ustr.size() - 1] != ' ') {
			ustr.append(uc(" "));
		}

		sprintf(numAC, "%d", ++numberI);
		ustr.append(uc(numAC));
	}
	
	strP->Set(ustr);
}

OSType		CharToOSType(const char *bufZ)
{
	OSType		osType;
	short		lenL = strlen(bufZ);
	
	osType = *((OSType *)(&bufZ[lenL - 4]));
	osType = OSSwapBigToHostInt32(osType);
	return osType;
}

CFURLRef		CFURLCreateWithUTF8(const UTF8Char *bufZ)
{
	ScCFReleaser<CFStringRef>			stringRef(CFStringCreateWithCu(bufZ));
	ScCFReleaser<CFStringRef>			urlStr(CFURLCreateStringByAddingPercentEscapes(
		kCFAllocatorDefault, stringRef, CFSTR("#"), NULL, kCFStringEncodingUTF8));

	return CFURLCreateWithString(kCFAllocatorDefault, urlStr, NULL);
}

char*	strrstr(const char* stringZ, const char* findZ)
{
	bool	firstB = true, doneB = false;
	char	*nextZ;
	
	do {
		if (firstB) {
			nextZ = strstr(stringZ, findZ);
		} else {
			nextZ = strstr(&stringZ[1], findZ);
		}
		
		doneB = nextZ == NULL;
		
		if (!doneB) {
			stringZ = nextZ;
		} else if (firstB) {
			stringZ = NULL;
		}
		
		firstB = false;		
	} while (!doneB);

	return const_cast<char *>(stringZ);
}

static	inline CFRange		CFStrGetRange(CFStringRef ref)
{
	return CFRangeMake(0, CFStringGetLength(ref));
}

void			CFStrReplaceWith(CFMutableStringRef stringRef, CFStringRef replaceStr, CFStringRef withStr)
{
	ScCFReleaser<CFArrayRef>	arrayRef;

	arrayRef.Set(CFStringCreateArrayWithFindResults(
		NULL, stringRef, replaceStr, CFStrGetRange(stringRef), 0));
	
	if (arrayRef.Get()) {
		CFRange			*rangeRef;

		loop_reverse (CFArrayGetCount(arrayRef)) {
			rangeRef = (CFRange *)CFArrayGetValueAtIndex(arrayRef, _indexS);
			CFStringReplace(stringRef, *rangeRef, withStr);
		}
	}
}

CFStringEncoding	ValidateEncoding(CFStringEncoding encoding)
{
	if (encoding == kCFStringEncodingInvalidId) {
		encoding = GetApplicationTextEncoding();
	}
	
	return encoding;
}

ustring	&CopyCFStringToUString(CFStringRef str, ustring &result, CFStringEncoding encoding, bool externalB)
{
	result.clear();
	
	if (str) {
		#define						kBufSize		256
		UTF8Char					utf8Buf[kBufSize];
		CFRange						cfRange = CFRangeMake(0, CFStringGetLength(str));
		CFIndex						resultSize;
		CFIndex						numChars;

		encoding = ValidateEncoding(encoding);

		while (cfRange.length > 0) {

			numChars = CFStringGetBytes(
				str, cfRange, encoding, '?', externalB, 
				&utf8Buf[0], kBufSize, &resultSize);

			if (numChars == 0) break;   // Failed to convert anything...

			result.append(&utf8Buf[0], &utf8Buf[resultSize]);
			
			cfRange.location	+= numChars;
			cfRange.length		-= numChars;
		}
	}
	
	return result;
}

std::string		&CopyCFStringToStd(
	CFStringRef			str, 
	std::string			&stdstr, 
	CFStringEncoding	encoding)
{
	stdstr.clear();
	
	encoding = ValidateEncoding(encoding);

	if (str) {
		const char	*charZ = CFStringGetCStringPtr(str, encoding);
		
		if (charZ) {
			stdstr = charZ;
		} else {
			ustring		ustr;
			
			CopyCFStringToUString(str, ustr, encoding);
			stdstr.append(ustr.begin(), ustr.end());
		}
	}

	return stdstr;
}

CFStringRef		CFStringCreateWithCu(
	const UTF8Char *	bufZ, 
	CFStringEncoding	encoding)
{
	return CFStringCreateWithC((const char *)bufZ, encoding);
}

CFStringRef		CFStringCreateWithC(
	const char *		bufZ, 
	CFStringEncoding	encoding)
{
	if (bufZ) {
		CFStringRef		cf = CFStringCreateWithCString(
			kCFAllocatorDefault, bufZ, ValidateEncoding(encoding));

		#if TRACK_RETAINS
			if (s_trackB) {
				LogPtr("CFRetain", cf);
			}
		#endif
		
		return cf;
	} else {
		return (CFStringRef)CFRetain(CFSTR(""));
	}
}

CFComparisonResult		CFStringCompare(CFStringRef str1, CFStringRef str2, bool case_sensitiveB)
{
	CFComparisonResult		compareResult = kCFCompareEqualTo;
	
	if (str1 == NULL || str2 == NULL) {

		if (str1 == NULL ^ str2 == NULL) {
			if (str1) {
				compareResult = kCFCompareLessThan;
			} else {
				compareResult = kCFCompareGreaterThan;
			}
		}
	} else {
		compareResult = ::CFStringCompare(
			str1, str2, (CFOptionFlags)(
			case_sensitiveB ? 0 : kCFCompareCaseInsensitive));
	}
	
	return compareResult;
}

bool		CFStringEqual(CFStringRef str1, CFStringRef str2, bool case_sensitiveB)
{
	return CFStringCompare(str1, str2, case_sensitiveB) == kCFCompareEqualTo;
}

bool		CFStringLess(CFStringRef lhs, CFStringRef rhs, bool case_sensitiveB)
{
	bool	lessB = CFStringCompare(lhs, rhs) == kCFCompareLessThan;
	
	return lessB;
}

bool		CFStringIsEmpty(CFStringRef nameRef)
{
	return nameRef == NULL || CFStringEqual(nameRef, CFSTR(""));
}

SuperString	&		SuperString::pop_back(UInt32 numCharsL)
{
	ustring		ustr(utf8());
	
	ustr.resize(ustr.size() - numCharsL);
	Set(ustr.c_str());
	return *this;
}

class SS_ForEach_Ascii {
	public: void operator()(char &ch) {
		if (ch < 32) ch = '?';
	}
};

SuperString		&SuperString::Ascii()
{
	CharVec		charVec;
	
	charVec.assign(std().begin(), std().end());
	
	std::for_each(charVec.begin(), charVec.end(), SS_ForEach_Ascii());
	charVec.push_back(0);
	Set(&charVec[0]);
	return *this;
}

SuperString		operator+(const SuperString &lhs, SuperString rhs)
{
	SuperString		str(lhs);
	
	str.append(rhs);
	return str;
}

void	SuperString::Set_p(ConstStr255Param strZ)
{
	CharVec		charVec;
	
	charVec.assign(&strZ[1], &strZ[strZ[0] + 1]);
	charVec.push_back(0);
	Set(&charVec[0]);
}

SuperString&	SuperString::ssprintf(void *nul, ...)
{
	CharVec		buf(2048);
	va_list		args;
	
	//	ASSERT(utf8().size() < 1024);
	va_start(args, nul);
	//	not thread safe!!
	vsprintf(&buf[0], utf8Z(), args);
	va_end(args);

	Set(uc(&buf[0]));
	return *this;
}

SuperString&	SuperString::Truncate(bool activeB, const Rect& frameR)
{
	ScCFReleaser<CFMutableStringRef>	str(CFStringCreateMutableCopy(kCFAllocatorDefault, 0, i_ref));

	(void)(TruncateThemeText(
		str, kThemeSmallSystemFont, activeB ? kThemeStateActive : kThemeStateInactive, 
		frameR.right - frameR.left, truncEnd, NULL));
	
	Set(str);
	return *this;
}

void			SuperString::ToUpper()
{
	ScCFReleaser<CFMutableStringRef>	capsRef(CFStringCreateMutableCopy(kCFAllocatorDefault, 0, i_ref));
	
	CFStringUppercase(capsRef, CFLocaleGetSystem());
	Set(capsRef);
}

void			SuperString::ToLower()
{
	ScCFReleaser<CFMutableStringRef>	capsRef(CFStringCreateMutableCopy(kCFAllocatorDefault, 0, i_ref));
	
	CFStringLowercase(capsRef, CFLocaleGetSystem());
	Set(capsRef);
}

OSType&		SuperString::pop_ext(OSType *extP) {
	*extP = GetExtension(c_str());
	return *extP;
}

bool			SuperString::IsAllCaps()
{
	ScCFReleaser<CFMutableStringRef>	capsRef(CFStringCreateMutableCopy(kCFAllocatorDefault, 0, i_ref));
	
	CFStringUppercase(capsRef, CFLocaleGetSystem());
	return *this == capsRef;
}

SuperString&	SuperString::InterCaps(bool allow_line_breaksB)
{
	ScCFReleaser<CFMutableStringRef>	capsRef(CFStringCreateMutableCopy(kCFAllocatorDefault, 0, i_ref));
	CFLocaleRef							locale(CFLocaleGetSystem());
	
	CFStringLowercase(capsRef, locale);
	CFStringCapitalize(capsRef, locale);
	
	if (!allow_line_breaksB) {
		CFStringRef		blankStr(CFSTR(""));
		
		CFStrReplaceWith(capsRef, SuperString(RETURN_STR).ref(), blankStr);
		CFStrReplaceWith(capsRef, SuperString(LINEFEED_STR).ref(), blankStr);
	}

	CFStringTrimWhitespace(capsRef);
	
	if (SuperString("Cavs") == capsRef) {
		CFStringUppercase(capsRef, locale);
	}
	
	Set(capsRef);

	return *this;
}

OSStatus	CopyHandle(const Handle srcH, Handle *destHP)
{
	*destHP = srcH;
	return HandToHand(destHP);
}

