//	FSUtils.h

#ifndef _H_FSUtils
#define	_H_FSUtils

#include "SuperString.h"

#define	kErr_FILE_IS_INVISIBLE	-12345

#define	kMaxFilePathLen			2048

typedef	std::vector<FSRef>		FSRefVec;

/************************************************/

void		FSUtils_PostDispose();

OSStatus		FSrGetResourceFolder(FSRef *fsRefP);
OSStatus		FSrGetExecutable(FSRef *fsRefP);

OSErr		DragWentToTrash(DragRef theDrag, Boolean *inTrashB);

OSErr	HFSFlavorDataFromDrag(
	DragReference	theDrag, 
	ItemReference	itemRef, 
	HFSFlavor		*hfsFlavor);
	
OSStatus		FSrResolveAsFarAsYouCan(
	const ustring	&utf8Path, 
	FSRef			*fileRef);

OSStatus	FSrResolveAlias(FSRef *fileRefP, UInt32 mountFlags = kResolveAliasFileNoUI);
OSErr		FSpResolveAlias(FSSpec *fileSpecP);
	
bool		FSrCanWriteToFolder(const FSRef &folderRef);

OSErr		FSpFindFolder(
	FSVolumeRefNum		vRefNum, 
	OSType				folderType, 
	FSSpec				*fileSpec);
	
OSErr			FSpGetFolderID(const FSSpec *folderSpecP, long *dirID);

OSErr		FSpCreateFileOrFolder(
	FSSpec		*fileSpecP, 
	OSType		fileType, 
	OSType		fileCreator, 
	Boolean		isFolderB);
	
OSStatus	FSrWriteFile(const FSRef &fileRef, void *dataP, size_t sizeL, bool pictB = false);
OSErr		FSFlushFile(short fileRefNum);

OSErr	FSpGetParentFolder(FSSpec *fileSpec, FSSpec *parentSpec);
OSErr	FSpGetParentVolume(FSSpec *fileSpec, FSSpec *parentSpec);

OSStatus	FSGetVolSize(FSVolumeRefNum vRefNum, UInt64 *freeSpaceL);
OSErr		FSGetVolDriveNum(FSVolumeRefNum vRefNum, short *driveNumS);
OSErr		FSpIsFolder(FSSpec *fileSpec, Boolean *isFolderB);
OSErr		FSpThisApp(FSSpec *appFSSpec);
OSErr		FSpLaunchInFinder(FSSpec *fileSpecP);
OSErr		FSpGetResEOF(FSSpec *fileSpec, UInt64 *resSize);
OSErr		FSpGetEOF(FSSpecPtr fileSpec, UInt64 *fileSize);
OSErr		FSpSetFileLock(FSSpec *fileSpecP, Boolean lockedB);
OSStatus	FSrGetFolderSize(const FSRef &folderRef, UInt64 *sizeLP);

OSErr	FSpCreateTempFile(
	FSVolumeRefNum		vRefNum, 
	ConstStr255Param	nameP, 
	OSType				fileCreator, 
	OSType				fileType, 
	FSSpec				*returnSpecP);
	
OSErr			FSpCountFilesInFolder(FSSpec *folderSpecP, unsigned long *numFilesL);

OSErr			FSpGetIndFileInFolder(
	FSSpec			*folderSpecP, 
	unsigned long	fileIndex, 
	FSSpec			*indFileSpecP);
	
Boolean		FSpEqual(
	const FSSpec	*spec1, 
	const FSSpec	*spec2);
	
OSErr		FSpGetFullPath(
	FSSpec	*specP, 
	short	maxPathLen, 
	char	*pathZ);
	
OSStatus	LaunchURL(const char *url_AC);

OSErr		FSrIsFolder(const FSRef &fileSpec, bool *isFolderB);

//OSErr		FSRefToBSD(const FSRef &volRef, char *pathZ, bool *is_cdB, bool test_audioB = false);
OSErr		FSVolRefNumToBSD(FSVolumeRefNum vRefNum, char *pathZ, bool *is_cdB, bool test_audioB = false);

OSErr		FSpFindOrCreateFolder(FSSpec &folder, Str255 strP, FSSpec *subDirP);
OSErr		FSpFindOrCreateFile(
	const FSSpec	&folder, 
	const Str255	strP, 
	OSType			fileType, 
	OSType			fileCreator, 
	FSSpec			*fileP,
	bool			*newB0 = NULL);

/****************************************************/
OSErr		FSrLaunchInFinder(const FSRef &fileRef);

OSErr		FSrFindFolder(
	FSVolumeRefNum		vRefNum, 
	OSType				folderType, 
	FSRef				*fileRef);

OSStatus	FSrCreateFromAEDesc(const AEDesc *descRef, FSRef *refP);
OSStatus	AEDescCreateFromFSRef(const FSRef &ref, AEDesc *descRef);
OSErr		AEDescListToRefVec(const AEDescList *docListP, FSRefVec	&refVec);
OSErr		AEGet1FSSpec(const AEDescList *docListP, FSSpec *fsSpecP);
OSErr		FSSpecFromDragRef(DragRef dragRef, Str32 fName, FSSpec *fsSpecP);
OSErr		AEGet1FSRef(const AEDescList *docListP, FSRef *fsRefP);

bool		FSrEqual(
	const FSRef		&ref1, 
	const FSRef		&ref2);

OSErr			FSrMakeFSSpec(
	const FSRef		&fileRef, 
	FSSpec			*specP);

OSErr		FSrCountFilesInFolder(const FSRef &folderRef, unsigned long *numFilesL);

OSErr		FSrGetIndFileInFolder(
	const FSRef		&folderRef, 
	unsigned long	fileIndex, 
	FSRef			*indFileRefP);

OSErr		FSrOnSameVolume(const FSRef &ref1, const FSRef &ref2, bool *sameB);

OSErr		FSrGetParentFolder(const FSRef &fileRef, FSRef *parentRef);
OSErr		FSrGetParentVolume(const FSRef &fileRef, FSRef *parentRef);

OSErr		FSrCopyNameRef(const FSRef &fileRef, CFStringRef *nameRefP);
OSStatus	FSrGetExtensionType(const FSRef &fileRef, OSType *typeP, SuperString *nameP = NULL);
OSErr		FSrGetName(const FSRef &fileRef, SuperString *superStrP);
OSErr		FSrGetName(const FSRef &fileRef, std::string *stdStringP);

OSErr		FSrOpenDF(
	const FSRef		&fileRef, 
	SInt8			permission,
	short *			refNum, 
	bool			keepTryingB = false);

OSStatus		FSrCreateFromPath(
	const ustring	&utf8Path, 
	FSRef			*fileRef);

/*
OSStatus		FSrCreateFromPath(
	const char *	path, 
	FSRef			*fileRef);

OSStatus	FSrGetPathC(
	const FSRef		&fileRef, 
	UInt32			maxPathSize, 
	char *			path);
*/

OSStatus	FSrGetPath(
	const FSRef		&fileRef, 
	SuperString		*superP);

OSStatus	FSrGetPath(
	const FSRef		&fileRef, 
	ustring			*pathP);

/*
OSStatus	FSrGetPathStd(
	const FSRef		&fileRef, 
	std::string		&path);
*/

OSErr		FSrThisApp(FSRef *appRef);
OSErr		FSrGetEOF(const FSRef &fileRef, UInt64 *fileSize);
OSErr		FSrSetEOF(const FSRef &fileRef, UInt64 fileSize);
OSStatus	FSrPadFile(const FSRef &fileRef, UInt64 loopNum, UInt64 sizeL, bool zeroB = true);

OSStatus	FSrTouchFile(FSRef &fileRef, bool touchCreDateB = false);

OSStatus	FSrDeleteEmptyFolders(const FSRef &folderRef, bool leaveRootB = false);
OSStatus	FSrDeleteFolder(const FSRef &folderRef, bool leaveRootB = false);
OSStatus	FSrGetSizeVec(const FSRefVec &refVec, UInt32Vec *sizeVecP, UInt32 multipleL = 0);

OSErr		FSrGetCatInfoBulk(
	const FSRef			&parFolderRef, 
	FSRefVec			&refVec);

OSErr		FSrCreateFromURL(
	CFURLRef		url, 
	FSRef			*fileRefP);

OSErr		FSrCreateURL(
	const FSRef		&fileRef, 
	CFURLRef		*urlP);

OSStatus	FSrGetFileDates(
	const FSRef	&fileRef, 
	DateTimeRec	*creDate, 
	DateTimeRec	*modDate);

OSStatus	FSrDeleteFile(FSRef *fileRefP, bool trashFirstB = false);
OSErr		FSrMoveToTrash(FSRef *fileRefP);

OSStatus		FSrLaunchWithApp(
	const FSRef &fileRef, 
	const FSRef &appRef, 
	bool		asyncB = false);

/*
OSErr	FSCopyObject(
	const FSRef *  ref,
	const FSRef *  destDirectory,
	FSRef *        newRef0);
*/

OSStatus	FSrMoveFile(const FSRef &dstFold, FSRef *srcFileP);

OSErr		FSrCopyFileToFolder(const FSRef &dstFold, FSRef *srcFileP, SuperString *destNameP0 = NULL);
OSErr		FSrCopyToFolder(const FSRef &dstFold, FSRef *srcFileP);
	
OSErr		FSrRevealInFinder(const FSRef &ref);

OSStatus	FSrIsVolume(const FSRef &fileRef, bool *isVolBP);

//	given "human readable" volume name, returns real FSRef and/or the "/Volumes/xxx/" path
OSStatus	FSrGetVolume(
	const SuperString	&searchName, 
	FSRef				*volRefP0 = NULL, 
	ustring				*pathP0 = NULL);

OSStatus	FSrFixVolumePath(ustring *pathP, FSRef *fsRefP0 = NULL);

//	given vRefNum, returns FSRef
OSErr		FSrGetVolume(FSVolumeRefNum vRefNum, FSRef *volRefP, char *pathZ = NULL, bool *is_cdB = NULL);
OSErr		FSrCopyVolumeName(FSVolumeRefNum vRefNum, CFStringRef *stringRefP);
OSStatus	FSrGetVolumeName(FSVolumeRefNum vRefNum, SuperString *strP);

//	given FSRef of any file on volume, returns vRefNum
//OSErr		FSrGetVRefNum(FSRef *fileRefP, FSVolumeRefNum *vRefNumP);
OSErr		FSrGetVRefNum(const FSRef &fileRef, FSVolumeRefNum *vRefNumP);
OSStatus	FSrEjectVolume(const FSRef& volRef);

OSStatus	FSRefVecFromDrag(DragReference theDrag, FSRefVec *refVecP);

OSErr	FSrFolderExists(
	const FSRef		&parentRef, 
	const UniString	&uniStr, 
	bool			*existsBP, 
	FSRef			*returnRefP0, 
	bool			resolveB = true);

OSErr	FSrFileExists(
	const FSRef		&parentRef, 
	const UniString	&uniStr, 
	bool			*existsBP, 
	FSRef			*returnRefP0 = NULL);

OSErr		FSrFindOrCreateFolder(
	const FSRef		&folder, 
	const UniString	&uniStr, 
	FSRef			*subDirP, 
	bool			*newBP0 = NULL);

OSErr		FSrFindOrCreateFile(
	const FSRef		&folder, 
	const UniString	&uniStr, 
	FSRef			*fileP, 
	OSType			fileType	= kFileType_WILDCARD, 
	OSType			fileCreator	= kFileType_WILDCARD, 
	bool			*newB0		= NULL);

OSStatus	FSrRename(
	FSRef			*fileRef,
	const UniString	&uniStr);

OSStatus	FSrUniqueName(
	const FSRef		&parentRef, 
	SuperString		*nameStrP, 
	bool			*changedBP0 = NULL);

OSStatus	FSrGetFileDates(
	const FSRef			&fileRef, 
   	CFAbsoluteTime		*modDateP0 = NULL, 
	CFAbsoluteTime		*creDateP0 = NULL);

OSStatus	FSrSetFileDates(
	FSRef				&fileRef, 
   	CFAbsoluteTime		*modDateP0 = NULL, 
	CFAbsoluteTime		*creDateP0 = NULL);

OSStatus	FSrGetFileDates(
	const FSRef		&fileRef, 
	DateTimeRec		*modDateP0 = NULL, 
	DateTimeRec		*creDateP0 = NULL);

OSStatus	FSrSetFileDates(
	FSRef		&fileSpec, 
	DateTimeRec	*modDate0 = NULL, 
	DateTimeRec	*creDate0 = NULL);


OSStatus		FSrExchangeFiles(FSRef *ref1P, FSRef *ref2P);
bool		GetEditNumber(SuperString *nameStrP, int *numSP);
void		AddEditNumber(SuperString *strP, char *bufZ0 = NULL);
OSStatus	FSrDuplicate(FSRef *refP, char *bufZ0 = NULL);

enum {
	kNameUpgrade_FILE, 
	kNameUpgrade_FOLDER
};

OSStatus		FSrUpgradeToSharedPrefs(FSRef *fileRefP);

OSStatus		FSrUpgradeName(
	const FSRef&	folderRef, 
	bool			is_folderB, 
	CFStringRef		newNameStr,
	FSRef			*objectRefP);

/*******************************************************/

class		CSafeSave {
	FSRef		&i_origFile;
	FSRef		i_file;
	FSRef		i_safeFile;
	FSRef		i_parentRef;
	
	public:	
	CSafeSave(FSRef &file) : i_origFile(file), i_file(file) { }
	
	operator FSRef()	{	return i_safeFile;	}
	OSStatus	Start();
	OSStatus	Finish();
};

class ScFSrMoveFile {
	const FSRef		&i_dstFolder;
	FSRef			*i_srcFileP;

	FSRef			i_srcFolder;
	OSStatus		err;
	
	public:	ScFSrMoveFile(
		const FSRef	&dstFolder, 
		FSRef		*srcFileP
	) : 
		i_dstFolder(dstFolder), 
		i_srcFileP(srcFileP), 
		err(noErr)
	{
		ERR(FSrGetParentFolder(*i_srcFileP, &i_srcFolder));
		ERR(FSrMoveFile(i_dstFolder, i_srcFileP));
	}
	
	~ScFSrMoveFile() {
		ERR(FSrMoveFile(i_srcFolder, i_srcFileP));
	}
	
	void		Release()	{	err = true;	}
};

class ScFSrRename {
	FSRef			*i_srcFileP;
	UniString		i_newName;

	SuperString		i_oldName;
	OSStatus		err;
	
	ScFSrRename(
		FSRef		*srcFileP, 
		UniString	newName
	) : 
		i_srcFileP(srcFileP), 
		i_newName(newName), 
		err(noErr)
	{
		ERR(FSrGetName(*i_srcFileP, &i_oldName));
		ERR(FSrRename(i_srcFileP, i_newName));
	}
	
	~ScFSrRename() {
		ERR(FSrRename(i_srcFileP, i_oldName));
	}
	
	void		Release()	{	err = true;	}
};

class ScFSrNewFolder {
	const FSRef		&i_dstFolder;
	UniString		i_newName;

	FSRef			i_newFolder;
	OSStatus		err;
	
	ScFSrNewFolder(
		const FSRef		&dstFolder, 
		UniString		newName
	) : 
		i_dstFolder(dstFolder), 
		i_newName(newName), 
		err(noErr)
	{
		ERR(FSrFindOrCreateFolder(i_dstFolder, i_newName, &i_newFolder));
	}
	
	~ScFSrNewFolder() {
		ERR(FSrDeleteFolder(i_newFolder));
	}
	
	void		Release()	{	err = true;	}
};

class	FSr_Sort_FileName_LessThan {
	public: bool operator()(const FSRef &ref1, const FSRef &ref2) const {
		OSErr			err = noErr;
		bool			lessB = true;
		SuperString		name1, name2;

		ERR(FSrGetName(ref1, &name1));
		ERR(FSrGetName(ref2, &name2));
		
		if (!err) {
			lessB = name1 < name2;
		}
		
		return lessB;
	}
};

#endif
