#ifndef _H_CFileRef
#define	_H_CFileRef

#include "SuperString.h"

class CFileRef {
	enum {
		FileRef_NONE,
		FileRef_FSREF	= 0x01, 
		FileRef_ALIAS	= 0x02, 
		FileRef_PATH	= 0x04
	};
	
	typedef unsigned short FileRefType;
	
	mutable FSRef	*i_fileRefP;
	AliasHandle		i_aliasH;
	SuperString		*i_pathP;
	
	void	Cleanup(FileRefType type = FileRef_NONE);
	
	void	zero() {
		i_fileRefP = NULL;
		i_aliasH = NULL;
		i_pathP = NULL;
		i_fileP = NULL;
	}
	
	public:
	CFileRef(const CFileRef& other);
	CFileRef()							{	zero(); }
	CFileRef(const ustring& path);
	CFileRef(const SuperString& path)	{	zero();	SetPath(path);	}
	CFileRef(const FSRef &fileRef)		{	zero();	operator=(fileRef);	}
	CFileRef(AliasHandle aliasH)		{	zero();	i_aliasH = aliasH;	}
	
	bool			IsFolder();
	bool			IsBundle();
	OSStatus		Duplicate();
	bool			IsValid()
	{
		return i_fileRefP != NULL
			|| i_aliasH != NULL
			|| i_pathP != NULL;
	}
	
	const SuperString&		GetPath();
	void					SetPath(const SuperString& path);
	
	SuperString				GetName();
	OSStatus				Rename(const SuperString& name);
	
	OSStatus				GetParent(FSRef *parRefP);
	OSStatus				Ascend();
	bool					GetRelativeFile(const SuperString& ext);

	//	if you don't pass anything for "existsB" then the child will be created
	OSStatus				GetChildFolder(const SuperString& child, bool *existsBP0 = NULL);
	OSStatus				GetChild(const SuperString& child, bool *existsBP0 = NULL, OSType fileType = '????', OSType fileCreator = '????');
	OSStatus				Descend(const SuperString& child);
	
	SuperString				GetExtension();
	OSType					GetExtensionType();
	
	operator FSRef&()		const;
	operator FSRef()		const {	return operator FSRef&();	}
	OSStatus				Delete(bool trashFirstB = false);
	OSStatus				Trash();
	
	FSRef&	operator =(const FSRef &ref);
	bool	operator==(const FSRef &other);

	bool	operator <(const CFileRef &other);
	
	private: FILE*		i_fileP;	public:
	operator FILE*()	{	return i_fileP;	}
	
	OSStatus		fopen(const char *accessZ);
	OSStatus		fclose();
	OSStatus		fread(char *bufP, long offsetL, size_t lengthL);
	void			fprintf(const char *str,...);
	SuperString		freadline();
	
	//	this fuction can throw!!
	UInt64			size();
	
	template<class Function> void for_each(Function f);
};

#endif